<?php
include 'conexao.php';
session_start();

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    // 1. Validar e sanitizar as entradas
    $turma_id = isset($_POST['turma_id']) ? (int)$_POST['turma_id'] : null;
    $disciplina_id = isset($_POST['disciplina_id']) ? (int)$_POST['disciplina_id'] : null;
    $trimestre = isset($_POST['trimestre']) ? (int)$_POST['trimestre'] : null;

    if (!$turma_id || !$disciplina_id || !$trimestre) {
        die("Parâmetros inválidos.");
    }

    // 2. Definir o nome dos campos de nota com base no trimestre
    // Sua lógica aqui estava incorreta, usando 'av1', 'av2', 'av3' para todos os trimestres
    $campo_av1 = 'av' . (1 + ($trimestre - 1) * 3);
    $campo_av2 = 'av' . (2 + ($trimestre - 1) * 3);
    $campo_av3 = 'av' . (3 + ($trimestre - 1) * 3);
    $campo_npt = 'npt' . $trimestre;
    $campo_mt = 'mt' . $trimestre;

    // 3. Processar os dados de cada aluno
    foreach ($_POST['aluno_id'] as $aluno_id) {
        $aluno_id = (int)$aluno_id;

        // 4. Capturar as notas enviadas do formulário
        $av1 = isset($_POST["av1_{$aluno_id}"]) && is_numeric($_POST["av1_{$aluno_id}"]) ? floatval($_POST["av1_{$aluno_id}"]) : null;
        $av2 = isset($_POST["av2_{$aluno_id}"]) && is_numeric($_POST["av2_{$aluno_id}"]) ? floatval($_POST["av2_{$aluno_id}"]) : null;
        $av3 = isset($_POST["av3_{$aluno_id}"]) && is_numeric($_POST["av3_{$aluno_id}"]) ? floatval($_POST["av3_{$aluno_id}"]) : null;
        $npt = isset($_POST["npt_{$aluno_id}"]) && is_numeric($_POST["npt_{$aluno_id}"]) ? floatval($_POST["npt_{$aluno_id}"]) : null;
        $mt = isset($_POST["mt{$trimestre}_{$aluno_id}"]) && is_numeric($_POST["mt{$trimestre}_{$aluno_id}"]) ? floatval($_POST["mt{$trimestre}_{$aluno_id}"]) : null;
        
        // 5. Verificar se já existe registro e preparar a consulta
        $sql = "SELECT id FROM notas WHERE aluno_id = ? AND disciplina_id = ? AND turma_id = ?";
        $checkStmt = $conn->prepare($sql);
        $checkStmt->bind_param("iii", $aluno_id, $disciplina_id, $turma_id);
        $checkStmt->execute();
        $resultado = $checkStmt->get_result();

        if ($resultado->num_rows > 0) {
            // Se o registro existe, fazemos um UPDATE
            $sql = "UPDATE notas SET
                    $campo_av1 = ?, $campo_av2 = ?, $campo_av3 = ?, $campo_npt = ?, $campo_mt = ?
                    WHERE aluno_id = ? AND disciplina_id = ? AND turma_id = ?";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("dddddiis", $av1, $av2, $av3, $npt, $mt, $aluno_id, $disciplina_id, $turma_id);

        } else {
            // Se o registro não existe, fazemos um INSERT
            $sql = "INSERT INTO notas (aluno_id, disciplina_id, turma_id, $campo_av1, $campo_av2, $campo_av3, $campo_npt, $campo_mt)
                    VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("iiiddddd", $aluno_id, $disciplina_id, $turma_id, $av1, $av2, $av3, $npt, $mt);
        }

        $stmt->execute();
        $stmt->close();
        $checkStmt->close();
    }

    // 6. Lógica para o 3º trimestre (MFD, NEO, NEE, MEC, MF)
    if ($trimestre === 3) {
        foreach ($_POST['aluno_id'] as $aluno_id) {
            $aluno_id = (int)$aluno_id;

            $mfd = isset($_POST["mfd_{$aluno_id}"]) && is_numeric($_POST["mfd_{$aluno_id}"]) ? floatval($_POST["mfd_{$aluno_id}"]) : null;
            $neo = isset($_POST["neo_{$aluno_id}"]) && is_numeric($_POST["neo_{$aluno_id}"]) ? floatval($_POST["neo_{$aluno_id}"]) : null;
            $nee = isset($_POST["nee_{$aluno_id}"]) && is_numeric($_POST["nee_{$aluno_id}"]) ? floatval($_POST["nee_{$aluno_id}"]) : null;
            $mec = isset($_POST["mec_{$aluno_id}"]) && is_numeric($_POST["mec_{$aluno_id}"]) ? floatval($_POST["mec_{$aluno_id}"]) : null;
            $mf = isset($_POST["mf_{$aluno_id}"]) && is_numeric($_POST["mf_{$aluno_id}"]) ? floatval($_POST["mf_{$aluno_id}"]) : null;

            $sql = "UPDATE notas SET mfd = ?, neo = ?, nee = ?, mec = ?, mf = ? WHERE aluno_id = ? AND disciplina_id = ? AND turma_id = ?";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("dddddiis", $mfd, $neo, $nee, $mec, $mf, $aluno_id, $disciplina_id, $turma_id);
            $stmt->execute();
            $stmt->close();
        }
    }

    // 7. Redirecionar com mensagem de sucesso
    echo "<script>alert('Notas salvas com sucesso!'); window.location.href='mini_pautas_professor.php?turma_id=$turma_id&disciplina_id=$disciplina_id&trimestre=$trimestre';</script>";
    exit;
}
?>